﻿local Event = require 'utils.event'
local Token = require 'utils.global_token'

-- code for disable technologie:
Event.add(defines.events.on_player_joined_game, function(event)
    local player = game.players[event.player_index]
        game.forces["player"].technologies["landfill"].enabled = false
				game.forces["player"].technologies["cliff-explosives"].enabled = false
        game.forces["player"].technologies["railway"].enabled = false
end)

-- code for Enemy Loot chance
local entity_drop_amount = {
    ['small-biter'] = {low = 1, high = 20},
    ['small-spitter'] = {low = 1, high = 20},
    ['medium-biter'] = {low = 20, high = 40},
    ['medium-spitter'] = {low = 20, high = 40},
    ['big-biter'] = {low = 40, high = 60},
    ['big-spitter'] = {low = 40, high = 60},
    ['behemoth-biter'] = {low = 60, high = 100},
    ['behemoth-spitter'] = {low = 60, high = 100}
}

local loot_raffle = {"iron-ore", "copper-ore", "coal", "stone", "landfill", "uranium-ore", "crude-oil-barrel"}

local loot = {
    ['iron'] = {weight = 200, name = 'iron-ore'},
	['copper'] = {weight = 120, name = 'copper-ore'},
	['coal'] = {weight	= 150, name = 'coal'},
	['stone'] = {weight = 50, name = 'stone'},
	['landfill'] = {weight = 20, name = 'landfill'},
	['uranium'] = {weight = 1, name = 'uranium-ore'},
	['oil'] = {weight = 0, name = 'crude-oil-barrel'}
}

local function randomize ()
	local return_value = nil
	local total_weight = loot['iron'].weight + loot['copper'].weight + loot['coal'].weight + loot['stone'].weight + loot['landfill'].weight + loot['uranium'].weight + loot['oil'].weight
	local rand_value = math.random(0, total_weight)
	if rand_value <  loot['iron'].weight then
		return loot['iron'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight) then
		return loot['copper'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight + loot['coal'].weight) then
		return loot['coal'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight + loot['coal'].weight + loot['stone'].weight) then
		return loot['stone'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight + loot['coal'].weight + loot['stone'].weight + loot['landfill'].weight) then
		return loot['landfill'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight + loot['coal'].weight + loot['stone'].weight + loot['landfill'].weight + loot['uranium'].weight) then
		return loot['uranium'].name
	end
	return loot['oil'].name
end

local function on_entity_died(event)
	local entity = event.entity
	if not entity or not entity.valid then
		return
	end
	local name = entity.name
	local bounds = entity_drop_amount[name]
	if bounds then
		local c = math.random(bounds.low, bounds.high)
		if c > 0 then
			local dropped = randomize()
			game.surfaces[1].spill_item_stack(entity.position,{name = dropped, count = c},true)
		end
	end
end

Event.add(defines.events.on_entity_died, on_entity_died)

local biter_building_inhabitants = {}
biter_building_inhabitants[1] = {{"small-biter",8,16}}
biter_building_inhabitants[2] = {{"small-biter",12,24}}
biter_building_inhabitants[3] = {{"small-biter",8,16},{"medium-biter",1,2}}
biter_building_inhabitants[4] = {{"small-biter",4,8},{"medium-biter",4,8}}
biter_building_inhabitants[5] = {{"small-biter",3,5},{"medium-biter",8,12}}
biter_building_inhabitants[6] = {{"small-biter",3,5},{"medium-biter",5,7},{"big-biter",1,2}}
biter_building_inhabitants[7] = {{"medium-biter",6,8},{"big-biter",3,5}}
biter_building_inhabitants[8] = {{"medium-biter",2,4},{"big-biter",6,8}}
biter_building_inhabitants[9] = {{"medium-biter",2,3},{"big-biter",7,9}}
biter_building_inhabitants[10] = {{"big-biter",4,8},{"behemoth-biter",3,4}}

local function on_entity_died(event)
    if event.entity.name == "biter-spawner" or event.entity.name == "spitter-spawner" then
        local e = math.ceil(game.forces.enemy.evolution_factor*10, 0)
        for _, t in pairs (biter_building_inhabitants[e]) do
            for x = 1, math.random(t[2],t[3]), 1 do
                local p = event.entity.surface.find_non_colliding_position(t[1] , event.entity.position, 6, 1)
                if p then event.entity.surface.create_entity {name=t[1], position=p} end
            end
        end
    end
end

Event.add(defines.events.on_built_entity, on_built_entity)
Event.add(defines.events.on_entity_died, on_entity_died)
Event.add(defines.events.on_player_rotated_entity, on_player_rotated_entity)
Event.add(defines.events.on_player_joined_game, on_player_joined_game)
